<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class Event extends Model 
{

    protected $table = 'events';
    public $timestamps = true;

    public function user()
    {
        return $this->belongsTo('User');
    }

    public function contact()
    {
        return $this->belongsTo('Contact');
    }

    public function category()
    {
        return $this->belongsTo('App\Models\EventCategory');
    }

    public function assets()
    {
        return $this->belongsToMany('App\Models\Asset');
    }

    public function ticket()
    {
        return $this->belongsTo('App\Models\Ticket');
    }

}